; WordPerfect 8.0 scripts version: 1.2.10
; For windows 95 and NT 4.0.
; Created by Sean Murphy
; Last Modified:  03/18/99 by j.c
;fixed hot key help for the spell checker
;also fixed double speaking in edit combo boxes
;Other script files which are used by WordPerfect 8.0 are:
;
; wpwpen
; comctl32
;
; Included header files.:
Include "WpWin8.jsm"
include "wpwin8.jsh"
include "hjconst.jsh"
include "hjglobal.jsh"
include "default.jsm"

Globals
	string temp

Script  ScriptFileName()
;announces the name of the aplication and currently executing script.
ScriptAndAppNames ("Corel Wordperfect 8 ")
EndScript

Function AutoStartEvent ()
;Initializes global variables and anounces welcome message.
Let ToolTip = WC_ToolTip ;assigns the tooltip window class name to the variable.
Let PropertyContextMenu = FALSE
If (WP8FirstTime == 0) Then
	Let WP8FirstTime = TRUE
	Say(WPMsg3, ot_message)
	Say(WPMsg4, ot_message)
	Say(WPMsg5, ot_message)
Else
	Refresh ()
EndIf
EndFunction

Int Function MoveToPriorCharacter (int Col, int Row)
RouteInvisibleToPc ()
InvisibleCursor ()
While (GetCharacter () == "")
	PriorCharacter ()
	If (Col == GetCursorCol ()) && (Row == GetCursorRow ()) then
		;Cursor has not moved or has not in counted a non null character.
		Return FALSE
	EndIf
EndWhile
;Found a non-null (printable) character.
Return TRUE
EndFunction

Int Function ControlCheckMarkDialogs (handle WHnd)
Var 	String TheClass
Let TheClass = GetWindowClass (WHnd) ;Class of the current window.
;This function returns a TRUE value for any dialogues that might have graphic check marks
;associated with them.  WC_GeneralDialog = Window Class name of #32770
If (TheClass == WC_GeneralDialog) || (TheClass == WC_PageSetup) Then
	Return TRUE
else
	Return FALSE
EndIf
 EndFunction

Script  ReadMisspelledAndSuggestion()
var
	handle WinHandle,
	Handle AppWindow,
	Handle NotFoundField,
	Handle ReplaceField

;Pause ()
Let AppWindow = GetAppMainWindow (GlobalFocusWindow)
let WinHandle = FindDescendantWindow (AppWindow, Cid_DialoguePage)
if StringContains (GetWindowName (WinHandle), strg1) then
	Let NotFoundfield = FindDescendantWindow (WinHandle, CId_NotFound_field)
	Let ReplaceField = FindDescendantWindow (WinHandle, CId_ReplaceWith_field)
	SayWindow (FindDescendantWindow (WinHandle, CId_NotFound_Prompt), 0)
	SaveCursor ()
	InvisibleCursor ()
	If MoveToWindow (NotFoundField) Then
		SayChunk ()
			SpellString (GetChunk ())
	EndIf
	Saywindow (FindDescendantWindow (WinHandle, CId_ReplaceWith_Prompt), 0)
	If MoveToWindow (ReplaceField) Then
		SayChunk ()
	SpellString (GetChunk ())
	EndIf
else
 	Say(WPErrorMsg2, ot_message) ; "you must be in the Spell Checker dialog to read misspelled word and suggestion"
EndIf
RestoreCursor ()
PcCursor ()
endScript

Script ReplaceMisspelledWord ()
var
	handle AppWindow, ;Aplication window handle
	Handle WinHandle, ;Window Handle
	int controlId ;control Id of the current window with focus.

let AppWindow = GetAppMainWindow (GlobalFocusWindow)
let WinHandle = FindDescendantWindow (AppWindow, CID_DialoguePage)
Let ControlId = GetControlId (GetFocus ())
Say(GetCurrentScriptKeyName (), ot_string)
if StringContains (GetWindowName (WinHandle), strg1) then
	;We are in the spell checker.
	If (ControlId == CId_ReplaceWith_Field) Then
		;Move the pc cursor to the replace button.
		{tab}
		{tab}
	ElIf  (controlId == CId_replacements_list) Then
		{tab}
	EndIf ;We are on the Replace with field or the suggestion list.
EndIf ;You are in a spell checker
{enter}
EndScript

Script  ReadWordInContext()
var
	handle WinHandle,
	Handle PriorWinHandle

let PriorWinHandle = GetFocus ()
Let WinHandle = GetAppMainWindow (GetFocus ())
Let WinHandle = FindDescendantWindow (WinHandle, Cid_MainEditwindow)
SaveCursor ()
InvisibleCursor ()
if moveToWindow (WinHandle) Then
	PriorCharacter () ; to include the case when the misspelled word is the first one on the window
	if (FindNextAttribute (attrib_highlight) &&
		(GetWindowClass (GetCurrentWindow ()) == wc_MainEditWindow)) then
		if (GetVerbosity () == beginner) then
			Say(WPErrorMsg3, ot_message) ; "Word in context:"
		EndIf
	SayLine ()
	else
		PCCursor ()
		Say(WpErrorMsg4, ot_message) ; "highlighted word not found"
	EndIf
else
	Say(WPErrorMsg5, ot_message) ; "main document window not found "
EndIf
RestoreCursor ()
PcCursor ()
EndScript

; *** Help section ***

string Function SayCursorPosition (string SearchString)
Var
	Handle WinHandle,
	String buffer
let WinHandle = GetAppMainWindow (GlobalFocusWindow)
SaveCursor ()
InvisibleCursor ()
Delay (DelayTime)
if MoveToControl (WinHandle, CId_StatusBar) then
	FindString (GetCurrentWindow (), SearchString, s_top, s_restricted)
	Let Buffer = GetWord ()
	NextWord ()
	Let Buffer = buffer + " " + getWord ()
	RestoreCursor ()
else
	Say(WPErrorMsg1, ot_message)
EndIf
Return buffer
EndFunction

; The following functions are modifications of their corresponding
;built-in or default ones
HANDLE Function GetRealWindow (handle FocusedWindow)
var
	handle WinHandle,
	handle RealWindow
let WinHandle = FocusedWindow
; search upward the hierarchy to get the handle of the highest
;dialog window
while (WinHandle)
	if (GetWindowType (WinHandle) == "dialog") Then
		let RealWindow = WinHandle
	EndIf
	let WinHandle = GetParent (WinHandle)
EndWhile
if (RealWindow == 0) then ; no dialog was found, then get the first window with name
	let WinHandle = FocusedWindow
	While (WinHandle && (GetWindowName (WinHandle) == ""))
		let WinHandle = GetParent (WinHandle)
	EndWhile
	let RealWindow = WinHandle
EndIf
return RealWindow
EndFunction

String Function GetWindowName (handle WinHandle)
var
	string FirstLine
SaveCursor ()
InvisibleCursor ()
MoveToWindow (WinHandle)
let FirstLine = GetLine ()
if (StringContains (FirstLine, strg1) &&
	StringContains (FirstLine, strg2) &&
	StringContains (FirstLine, strg3)) then
	return strg1 + ", " + strg2 + ", " + strg3 + " Dialog"
EndIf
return GetWindowName (WinHandle)
EndFunction




Void Function SayGeneralStatus (handle hwnd, string buffer, int nAttributes, int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
If (SFrameName == "GeneralStatusLow") &&
(buffer != "") Then
	Let ScreenRes = LOW
else
	Let ScreenRes = MEDIUM
EndIf
If (PriorInsertStatusFrameBuffer != Buffer) Then
	Let PriorInsertStatusFrameBuffer = buffer
else
	Return
endIf
If Stringcontains (Buffer, "Insert")
  || StringContains (buffer, "Typeover") Then
	Say(buffer + WPMsg1, ot_buffer)
else
	Say(buffer, ot_buffer)
EndIf
EndFunction

Function SayFocusedWindow ()
var
	Handle AppWindow, ;Window handle of the APPLICATION WINDOW
	Handle WinHandle, ;Window Handle
	String TheClass, ;The window class name.
	Int PrevControlId, ;Previous control id that the focus was on.
	Int ControlId ;current control Id of window class.

Let TheClass = GetWindowClass (GlobalFocusWindow)
Let WinHandle = FindDescendantWindow (AppWindow, CID_DialoguePage)
Let ControlId = GetControlId (GlobalFocusWindow)
Let PrevControlId = GetControlId (GlobalPrevFocus)
Let AppWindow = GetAppMainWindow (GlobalFocusWindow)
;announces when the focus is on the main edit window.
if (TheClass == WC_MainEditWindow) Then
	Say(WPMsg2, ot_message) ;"edit"
EndIf
;Checks for the spell check, Thesaurus and Gramatik dialogue.
;strg1 = Spell checker.
if StringContains (GetWindowName (WinHandle), strg1) then
	If (ControlID == CId_Replace_With)
	 || (ControlId == CId_Synonym)
	 || (ControlId == CId_Synonym2)
	 || (ControlId == CId_Synonym3)
	 || (ControlId == CId_Definitions ) Then
		;we are in the Thesaurus.
		PerformScript  ThesaurusWord ()
		Return
	EndIf
	If (ControlID == Cid_Replacement) then
		;We are in the Grammatik.
		;not available yet.
		Return
	EndIf
	if (ControlID == CId_ReplaceWith_field) then
;	we are in the Spell Checker dialog, do not announce the new focus.
		If (PrevControlId == CId_DialoguePage) ||
		 (PrevControlId == CId_replacements_list) Then
			SayWindowTypeAndText (GlobalFocusWindow)
		EndIf
		return
	EndIf
EndIf
;Detects for the Find and replace dialogue
If (GetWindowClass (GetParent (GetParent (GlobalFocusWindow))) == Wc_FindAndReplace) Then
	SayFindPrompt ()
EndIf
;the next if test checks to see if the current dialog uses graphic check marks.
If ControlCheckMarkDialogs (GetRealWindow (GlobalFocusWindow)) Then
	SayDialogText ()
	SayControlGraphic ()
EndIf
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Void Function SayHighlightedText (handle hwnd, string buffer)
	Var
	Handle HWin

Let HWin = FindDescendantWindow (GetAppMainWindow (GlobalFocusWindow), CID_dialoguePage)
If (GetWindowSubtypeCode (GetCurrentWindow ()) == 41) then
Return
endIf


;Checks to see if the spell checker is active.
;strg1 = "spell checker"
if StringContains (GetWindowName (HWin), strg1)  Then
; The spell checker dialogue is active.
	If (GetControlId (Hwnd) == CId_MainEditWindow) Then
	;A misspelled word was found, execute readMisspelledAndSuggestion script.
		PerformScript ReadMisSpelledAndSuggestion ()
  Return
	endIf ;GetControlId (hwnd) == CId_MainEditWindow
	Return
EndIf ;You are currently in the spell checker.
if(GetScreenEcho() > 0) Then
	Say(buffer, ot_buffer)
EndIf
EndFunction

Void Function SayNonHighlightedText (handle HWnd, string Buffer)
var
	string TheClass, ;The window class name of the current window.
	Int PageNum, ;Current Page number.
	Int ParentControlID, ;Control id of the previous window.
	Int ControlID ;Control id of the current window.

Let TheClass = GetWindowClass (Hwnd)
Let ParentControlID = GetControlID (GetParent (Hwnd))
Let ControlId = GetControlID (hwnd)

;Following if test is from the default script.
If ((GetScreenEcho() > 1)
   ;wn36="#32771"
   || (TheClass == wn36 )) then
	Say(buffer, ot_buffer)
	Return
EndIf
;Checks to see if the automatic page number option is turned on and
	;if new text was written to the status bar.
If autoSayPageNo && (controlId == CId_StatusBar) Then
	;Extracts the page number information off the status bar and storesit the buffer variable.
	let buffer = SayCursorPosition (PageNo)
	Let PageNum = StringToInt (SubString (Buffer, 3, StringLength (Buffer)))
	;checks to see if the page number has changed.
	If (PriorPageNo != PageNum) Then
		Say(Buffer, ot_buffer) ;announce the new page number.
		;Save current page number to prevent it from being spoken again.
		Let PriorPageNo = PageNum
	EndIf ;(PriorPageNo != PageNum)
	Return
EndIf ;autosayPageNo && (ControlId == CId_StatusBar)
;The following "If" test checks for the appearance of the
;Tool Tip.  when it appears, then the tool tip is announced,
;only at beginner verbosity level.
If (TheClass == ToolTip)
 && (GetVerbosity () == BEGINNER) Then
	Say(buffer, ot_buffer) ;wpmsg43 = "tooltip is: "
	Return
EndIf
;If any of the windows on the toolbar were activated.  This if test insures that the
;Pc cursor is left in the main edit window.
If PropertyContextMenu && GetFocus () == 0 Then
	routeInvisibleToPc ()
	InvisibleCursor ()
	MoveTo (GlobalXPos, GlobalYPos)
	RoutePcToInvisible ()
	RouteJawsToPc ()
	PcCursor ()
	Refresh ()
	Let PropertyContextMenu = FALSE
	Return
EndIf
EndFunction

Void Function SayFindPrompt ()
Var
	Handle Hwnd,
	Handle RealWin

Let Realwin = GetRealwindow (GlobalFocuswindow) ;Handle of real window.
;Handle of the edit prompt static text.
Let Hwnd = FindDescendantWindow (RealWin, CId_Find_Prompt)
If (GetControlId (GetParent (GlobalFocusWindow)) == CId_EditfindPrompt) Then
	saywindow (Hwnd, 0)
endIf
Return
EndFunction

Void Function SayDialogText ()
Var
	String theTitle, ;Title of the current dialogue.
	Int Controlid, ;control id of the current window.
	String TheLine, ;Stores the current line for processing purposes.
	String LastLine ;stores the last line of the dialogue.

Let ControlId = GetControlid (GlobalFocusWindow)
Let TheTitle = GetWindowName (GetRealWindow (GlobalFocusWindow))
If (TheTitle == WN_ExitWordPerfect) ||
  (TheTitle == Wn_FindAndReplace) ||
 (TheTitle == WN_WPWinError) Then
	If (GetWindowClass (GlobalPrevFocus) != GetWindowClass (GlobalFocusWindow)) Then
				SaveCursor ()
		InvisibleCursor ()
		RouteInvisibleToPc ()
		Let LastLine = GetLine ()
		JawsPageUp ()
		NextLine ()
		Let theLine = GetLine ()
		while (LastLine != theLine)
			Say(theLine, ot_string)
			NextLine ()
			Let TheLine = GetLine ()
		endWhile
			 				RestoreCursor ()
		PcCursor ()
	endIf
EndIf
EndFunction


void Function SaycontrolGraphic ()
Var
	Int TheTypeCode, ;The current window Type code
	Int ControlId ;the current window control id.

Let TheTypeCode = GetWindowtypeCode (globalFocusWindow)
Let controlId = GetcontrolId (GlobalFocusWindow)
If (TheTypeCode == WT_BUTTON)
|| (TheTypeCode == WT_LISTBOX) then
	SaveCursor ()
	RouteInvisibleToPc ()
	InvisibleCursor ()
	PriorWord ()
	If (GetControlId (GetCurrentWindow ()) == ControlId) &&
	(GetCharacterAttributes () & Attrib_Graphic) then
		SayWord ()
	EndIf
	RestoreCursor ()
	PcCursor ()
EndIf
EndFunction

Script ThesaurusWord ()
Var
	Int ControlId,
	String BackGroundcolour,
	String ForeGroundColour,
	Handle RealWindow

Let RealWindow = GetRealWindow (globalFocusWindow)
Let ControlId = GetControlId (globalFocusWindow)
;checks to see if the Thesaurus has no definitions available.
If FindDescendantWindow (RealWindow, 106)
 && (GetWindowTypecode (GlobalFocusWindow) == WT_LISTBOX) Then
	Say(WPMsg8, ot_message)
	;gets the previous control id which announces the previous replacement word.
	Let ControlId = controlId - 1
	SayWindow (FindDescendantWindow (Realwindow, ControlId), 0)
	Say(WPMsg9, ot_message)
	PcCursor ()
Else
;definition list is available.
	If (ControlId == CId_Definitions) || (ControlId == CID_Synonym) Then
		SaveCursor ()
		RouteInvisibleToPc ()
		InvisibleCursor ()
		PriorLine ()
		Let BackGroundColour = GetColorName (GetColorBackground ())
		Let ForeGroundColour = GetColorName (GetColorText ())
		If (BackGroundColour == "white") && (ForeGroundColour == "Blue") Then
			SayControl (GetPriorWindow (GetCurrentWindow ()))
;			SayWord ()
			SayChunk ()
			Say(GetWindowType (GlobalFocusWindow), ot_control_name)
			Saywindow (globalFocusWindow, 1)
			Return
		EndIf
		RestoreCursor ()
		PcCursor ()
	EndIf
endIf
SayWindowTypeAndText (GlobalFocusWindow)
EndScript

Script SayIndentPosition ()
Var
	String ScriptKeyName,
	String theClass,
	Handle RealWindow, ;Window handle of the window with the title.
	Int ControlId ;current control Id of window class.

Let RealWindow = GetRealWindow (GlobalFocusWindow)
Let TheClass = GetWindowClass (GlobalFocusWindow)
Let ControlId = GetControlId (GlobalFocusWindow)
Let ScriptKeyname = GetcurrentScriptKeyName ()
If (ScriptKeyName == "tab") Then
	{Tab}
ElIf (ScriptKeyName == "shift+Tab") Then
	{shift+tab}
elIf (ScriptKeyName == "f7") Then
	{F7}
ElIf (ScriptKeyName == "Alt+F7") Then
	{alt+f7}
ElIf (ScriptKeyName == "Control+F7") Then
	{Control+F7}
ElIf (ScriptKeyName == "Control+Shift+F7") Then
	{Control+shift+f7}
ElIf (ScriptKeyName == "Shift+F7") Then
	{shift+f7}
ElIf (ScriptKeyName == "control+r") Then
	{control+r}
ElIf (ScriptKeyName == "control+l") Then
	{control+l}
ElIf (ScriptKeyName == "control+e") Then
	{control+e}
EndIf
	Say(ScriptKeyname, ot_string)
if (ControlId == CId_MainEditWindow)
 && (theClass == wc_MainEditWindow) then
	Delay (Delaytime)
	Say(SayCursorPosition (CharacterPos), ot_position)
EndIf
EndScript

Script SayWpCoordinates ()
Var
	String Buffer ;stores the return string value.

Let Buffer = SayCursorPosition (PageNo)
If (Buffer != "") Then
	Let buffer = buffer + " " + SayCursorPosition  (LineNo)
	let buffer = buffer + " " + SayCursorPosition (CharacterPos)
	Say(buffer, ot_buffer)
EndIf
EndScript

Script OpenFontWindow ()
Var
	Handle HWnd ;Handle of window.

Let Hwnd = FindDescendantWindow (GetAppMainWindow (GlobalFocusWindow), CId_FontWindow)
If IswindowVisible (HWnd) Then
	Let GlobalXPos = GetCursorCol ()
	Let GlobalYPos = GetCursorRow ()
	MoveToWindow (HWnd)
	Say(WPMsg11, ot_message)
;The following delay is necessary to allow the above string to be spoken.
	Delay (Delaytime)
	LeftMouseButton ()
EndIf
PcCursor ()
Let PropertyContextMenu  = TRUE
EndScript

Script OpenPointSizeWindow ()
Var
	Handle Hwnd ;Handle of window

Let HWnd = FindDescendantWindow (GetAppMainWindow (GlobalFocusWindow), CId_PointSizeWindow)
If IswindowVisible (HWnd) Then
	Let GlobalXPos = GetCursorCol ()
	Let GlobalYPos = GetCursorRow ()
	MoveToWindow (Hwnd)
	Say(WPMsg12, ot_message)
;The following delay is necessary to allow the above string to be spoken.
Delay (Delaytime)
	LeftMouseButton ()
EndIf
PcCursor ()
Let PropertyContextMenu  = TRUE
EndScript

Script OpenStyleWindow ()
Var
	Handle Hwnd ;Handle of window.

Let HWnd = FindDescendantWindow (GetAppMainWindow (GlobalFocusWindow), CId_StyleWindow)
If IswindowVisible (HWnd) Then
	Let GlobalXPos = GetCursorCol ()
	Let GlobalYPos = GetCursorRow ()
	MoveToWindow (HWnd)
	Say(WPMsg13, ot_message)
;The following delay is necessary to allow the above string to be spoken.
	Delay (Delaytime)
	LeftMouseButton ()
	{down arrow}
EndIf
PcCursor ()
Let PropertyContextMenu  = TRUE
EndScript


Script OpenPromptAsYouGo ()
Var
	Handle AppWin, ;the Application window handle.
	Int Forecolor, ;foreground color of text.
	Int Backcolor, ;Stores the background color of the text.
	Handle Hwnd, ;window handle of the Prompt as you go window.
	String Word ;Current word the cursor is on.

If (GetWindowClass (GetCurrentwindow ()) == WC_MainEditwindow) Then
		Let AppWin = GetAppMainWindow (GetCurrentWindow ()) ;application window handle
	;The following line finds the Prompt as you go edit combo box window handle.
	Let Hwnd = FindDescendantWindow (Appwin, CId_MisspelledWindow)
	;The next two lines stores the pc cursor location.
	;To prevent the focus being lost.
	Let GlobalXPos = GetCursorCol ()
	Let GlobalYPos = GetCursorRow ()
	;Store the current word where the pc cursor is situated.
	Let Word = GetWord ()
	SaveCursor ()
	JawsCursor ()
	;There is two windows associated with the prompt as you go window.
	;the first window is an edit combo box which has an unique control id.
	;this is obtain by the FindDecendentWindow function found above.
	;The test tries to move to this combo box window.
	If MoveToWindow (Hwnd) Then
		;The second window (the first child window of the combo box) is the actual edit box
		;with the first correction in it.  the following function moves the jaws cursor to this
		;window.
MoveToWindow (GetFirstChild (HWnd))
		;Assigning the foreground an dbackground to the variables.
	SayWindow (GetCurrentWindow (), 0)
		;Store the foreground and background colours.
		Let ForeColor = GetColorText ()
		Let BackColor = GetColorBackGround ()
		If (GetWord () == "") then
			Say(WPMsg19 +word, ot_message)
			Say(WPMsg20, ot_message)
			Return ;Nothing in the prompt as you go window.
		EndIf ;(GetWord == "")
		;Activate the Prompt as you go window.
		LeftMouseButton ()
	;The following "If" test checks the color that the cursor is on.
	;If the colors are Red on White, then the
	;current word is misspelled and the quick spell checker is active.
		If (GetColorName (ForeColor) == "Red")
		  && (GetColorName (BackColor) == "white") Then
			Say(WPmsg14+Word, ot_message)
			SpellString (Word)
			Say(WPMsg15, ot_message)
		ElIf (GetColorName (ForeColor) == "blue")
		 && (GetColorName (BackColor) == "white") Then
			Say(WPMsg16, ot_message)
			Say(WPMsg17, ot_message)
		ElIf (GetColorName (ForeColor) == "black")
		 && (GetColorName (BackColor) == "white") Then
			Say(WPMsg21, ot_message)
			Say(WPMsg22, ot_message)
			Say(Word, ot_word)
		EndIf ;end of checking the colors.
	EndIf ;Move to Misspelled window
	Let PropertyContextMenu  = TRUE
EndIf ;Focus is in the main edit window.
EndScript

Script DocumentContextMenu ()
;The "If" test checks to see if the active cursor is inside the document
;window.  If the condition is false, then nothing happens.
If (GetWindowclass (GetFocus ()) == wc_MainEditWindow) Then
	RouteJAWSToPc ()
	JawsCursor ()
	RightMouseButton ()
	PcCursor ()
EndIf
EndScript


Script SayTableCell ()
Var
	String ScriptKeyName, ;stores the current key that envoked the script.
	int controlId, ;stores the current control id.
	Int IsTable, ;Is the focus in a table.
	String Buffer ;stores the first line of the cell.
Let ScriptKeyname = GetcurrentScriptKeyName ()
let controlId = GetcontrolId (GlobalFocusWindow)
If (ScriptKeyName == "Alt+LeftArrow") Then
	{alt+left arrow}
	Let buffer = GetChunk ()
	Let IsTable = TRUE
ElIf (ScriptKeyName == "Alt+RightArrow") Then
	{alt+right Arrow}
	Let buffer = GetChunk ()
	Let IsTable = TRUE
elIf (ScriptKeyName == "Alt+DownArrow") Then
	If (ControlId == CId_MainEditWindow) Then
		{alt+down arrow}
		Let buffer = GetChunk ()
		Let IsTable = TRUE
	Else
		PerformScript OpenListbox ()
	EndIf ;controlId == CId_MainEditwindow
ElIf (ScriptKeyName == "Alt+UpArrow") Then
	If (ControlId == CId_MainEditWindow) Then
		{alt+up arrow}
		Let Buffer = GetChunk ()
		Let IsTable = TRUE
	Else
		PerformScript OpenListbox ()
	EndIf ;controlId == CId_MainEditwindow
EndIf ;finished checking for keys that are linked to script.
;If the test is TRUE, then the buffer is announced.
If IsTable Then
	If (Buffer == "") Then
		Say(WPMsg28, ot_message)
	else
		Say(buffer, ot_buffer)
	endIf ;buffer == ""
endIf ;IsTable
EndScript


Script InsertMode ()
{insert}
EndScript


Script SayCurrentGeneralStatus ()
Var
	String Buffer

If (ScreenRes == Low) Then
	;Get the frame that has been set up for 640 by 480 resalution.
	Let Buffer = GetTextInFrame ("GeneralStatusLow")
elIf (ScreenRes == Medium) Then
	Let buffer = GetTextInFrame ("GeneralStatusMedium")
EndIf
If (Buffer == "") Then
	Say(WPerrorMsg6, ot_message)
else
	Say(buffer, ot_buffer)
EndIf
EndScript

Script  ScreenSensitiveHelp()
var
	String TheClass

Let TheClass = GetWindowClass (GetCurrentWindow ())
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
;The next if test checks to see if the current window class belongs to the wp document window and
; that the menu bar is not active.
If (TheClass == wc_MainEditWindow) && (GlobalMenuMode == 0) Then
	Say(WPHelpMsg1, ot_help)
	Say(WPHelpMsg2, ot_help)
	Say(WPHelpMsg3, ot_help)
	return
else
	performScript ScreenSensitiveHelp ()
EndIf
EndScript

Script  HotKeyHelp()
var
	handle WinHandle,
	String TheClass,
int IControlID
let IControlID = GetControlID (GetCurrentWindow ())
let WinHandle = GetFocus ()
Let TheClass = GetWindowClass (WinHandle)
if (TheClass == wc_MainEditWindow) then
	Say(WPHelpMsg4, ot_help)
	Say(WPHelpMsg5+GetScriptKeyName ("SayWPCoordinates"), ot_help)
	Say(WPHelpMsg11+GetScriptKeyName ("OpenFontwindow"), ot_help)
	Say(WPHelpMsg12+GetScriptKeyName ("OpenPointSizeWindow"), ot_help)
	Say(WPHelpMsg13+GetScriptKeyName ("OpenStyleWindow"), ot_help)
Say(WPHelpMsg14+GetScriptKeyName ("OpenPromptAsYouGo"), ot_help)
	Say(WPHelpMsg32+GetScriptKeyName ("WindowKeysHelp"), ot_help)
	return
EndIf
if StringContains (GetWindowName (FindDescendantWindow (GetAppMainWindow (GlobalFocusWindow), CID_dialoguePage)), strg1) then
	Say(WPHelpMsg9+GetScriptKeyName ("ReadMisspelledAndSuggestion"), ot_help)
	Say(WPHelpMsg10 + GetScriptKeyName ("ReadWordInContext"), ot_help)
	return
EndIf
HotKeyHelpDefaultLoop ()  ; standard dialog boxes
EndScript

Script  WindowKeysHelp()
var
	handle WinHandle,
	String TheClass
let WinHandle = GetFocus ()
Let TheClass = GetWindowClass (WinHandle)
if (TheClass == wc_MainEditWindow) then
	Say(WPHelpMsg15, ot_help)
	Say(WPHelpMsg16, ot_help)
	Say(WPHelpMsg17 , ot_help)
	Say(WPHelpMsg18, ot_help)
	Say(WpHelpMsg19, ot_help)
	Say(WpHelpMsg20, ot_help)
	Say(WpHelpMsg21, ot_help)
	Say(WPHelpMsg22, ot_help)
	Say(WpHelpMsg23, ot_help)
	Say(WpHelpMsg24, ot_help)
	Say(WpHelpMsg25, ot_help)
	Say(WpHelpMsg26, ot_help)
	Say(WpHelpMsg27, ot_help)
		Say(WpHelpMsg28, ot_help)
		Say(WpHelpMsg29, ot_help)
		Say(WPHelpMsg30, ot_help)
		Say(WpHelpMsg31, ot_help)
	return
EndIf
WindowKeysHelpDefault ()
EndScript


Script DeleteWord ()
{control+backspace}
SayWord ()
EndScript


Script DeleteToEndOfLine ()
{control+delete}
SayLine ()
EndScript

Script SayWindowTitle ()
Var
	Handle RealWin,
	Handle SpellcheckWindow

Let RealWin = GetRealWindow (globalFocusWindow)
Let SpellCheckWindow = GetFirstChild (FindDescendantWindow (RealWin, Cid_DialoguePage))
If StringContains (GetWindowName (SpellCheckWindow) , STRG1) Then
	Say(GetWindowName (SpellCheckWindow), ot_window_name)
ElIf (GetWindowClass (RealWin) == Wc_GeneralDialog )
 && (!IsMultiPageDialog ()) Then
		Say(WpMsg44+GetWindowName (RealWin), ot_window_name); "Title is: "
Else
PerformScript SayWindowTitle ()
EndIf
EndScript

Script ToggleBoldAttrib ()
AttributeStatus (Attrib_Bold, WPMsg30, WPMsg29, WPMsg35)
{control+b}
EndScript

Script ToggleUnderLineAttrib ()
AttributeStatus (Attrib_UnderLine, WPMsg32, WPMsg31, WPMsg36)
{control+u}
EndScript

Script ToggleItalicAttrib ()
AttributeStatus (Attrib_Italic, WPMsg34, WPMsg33, WPMsg37)
{control+i}
EndScript


Void Function AttributeStatus (int Attribute, string AttribOff, string AttribOn, string AttribHighlighted)
Var
	String TheClass ;Current window class

Let TheClass = GetWindowClass (GlobalFocusWindow) ;Stores the current window class name.
If (TheClass == WC_Maineditwindow) then
	;Currently in the main edit document window.
	If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
		;Text is highlighted, announce the new attribute change.
		Say(AttribHighlighted, ot_string)
		Return ;exit back to calling routeroutine.
	endIf
RestrictCursor (ON)	;text is not highlighted.
	If Not MoveToPriorCharacter (GetCursorCol (), GetCursorRow ()) Then
		;Assume that the attribute was turned on for the first time and announce this fact.
		Say(AttribOn, ot_string) ;announce that the attribute has been turned on.
	else
	;Found the prior character and now we need to check the current attribute
	;of this found character.
		If (GetCharacterAttributes () & Attribute) then
		;since the prior character is the same attribute.  The attribute has been turned off.
			Say(AttribOff, ot_string) ;announce that the attribute has been turned off.
		Else
			;The previous attribute was different, so the new attribute was just turn on.
			Say(AttribOn, ot_string) ;Announce that the attribute has been turned on.
		endIf ;(GetCharacterAttributes () & Attribute)
	EndIf ;End if MoveToPriorCharacter
RestrictCursor (OFF)
	PcCursor ()
EndIf ;(Controlid == CId_MainEditWindow)
EndFunction

void Function SayAttribute ()
Var String strAttribColl
Let strAttribColl = ""
If (GetCharacterAttributes () & Attrib_Bold) then
	Let strAttribColl = strAttribColl + WPMsg38   ;"bold"
EndIf
If (GetCharacterAttributes () & Attrib_Underline) then
	Let strAttribColl = strAttribColl + WPMsg39   ;"UnderLine"
EndIf
If (GetCharacterAttributes () & Attrib_Italic) then
	Let strAttribColl = strAttribColl + WPMsg40   ;"Italic"
EndIf
If (GetCharacterAttributes () & Attrib_StrikeOut) then
	Let strAttribColl = strAttribColl + WPMsg41   ;"Strike out"
EndIf
If (GetCharacterAttributes () & Attrib_Highlight) then
	Let strAttribColl = strAttribColl + WPMsg42   ;"Highlighted"
EndIf
If (strAttribColl == "") then Let strAttribColl = strAttribColl + WPNormalFontMsg EndIf   ; "Normal"
Say (strAttribColl, ot_message)
EndFunction

String Function GetFont ()
Var
  Handle FWin, ;The handle of the font edit combo box window.
  String FontName, ;Font name.
  Handle AppWin ;The application window handle.
Let AppWin = GetAppMainWindow (GlobalFocusWindow) ;Assign the application window handle to Appwin.
let FWin  = FindDescendantWindow (AppWin, CId_Fontwindow)
Let FontName = ""
Let FontName = GetWindowText (FWin, FALSE)
If (FontName == "") then
  Let FontName = GetCharacterFont ()
EndIf
RouteJawsToPc ()
PcCursor ()
Return FontName
EndFunction

int Function GetFontPointSize ()
Var
  Handle pWin, ;The handle of the font edit combo box window.
  String Buffer, ;Stores the string value of the point size.
  Int PointSize, ;Font point size.
  Handle AppWin ;The application window handle.
Let AppWin = GetAppMainWindow (GlobalFocusWindow) ;Assign the application window handle to Appwin.
let PWin  = FindDescendantWindow (AppWin, CId_PointSizeWindow)
Let PointSize = 0
Let PointSize = StringToInt (GetWindowText (PWin, FALSE))
If (PointSize == "") Then
  Let PointSize = GetCharacterPoints ()
EndIf
RouteJawsToPc ()
PcCursor ()
Return PointSize
EndFunction

Script SayFont ()
Var
  Handle FWin, ;The handle of the font edit combo box window.
  Handle AppWin ;The application window handle.
Let AppWin = GetAppMainWindow (GlobalFocusWindow) ;Assign the application window handle to Appwin.
let FWin  = FindDescendantWindow (AppWin, CId_Fontwindow)
SayActiveCursor ()
If (IswindowVisible (FWin) == FALSE) Then SayFont ()
  If (GetVerbosity () == BEGINNER) then Say (WP_MoreAccurateFontInfoMsg, ot_message) EndIf
  Return
EndIf
Say(WPMsg10, ot_message)
Say (GetFont (), ot_font)
SayInteger (GetFontPointSize ())
Say(WPMsg7, ot_message)
SayAttribute ()
EndScript

Script SayPriorLine ()
Var
	Handle HWnd,
	String FontName, ;Name of font.
	Int PointSize, ;Point Size of font.
	Handle RealWindow, ;Real window handle.
	String TheClass ;The current window class.

Let RealWindow = GetRealWindow (GetcurrentWindow ())
Let HWnd = GetCurrentwindow ()
	Let TheClass = GetWindowclass (Hwnd)
If IsPCCursor ()
 && ControlCheckMarkDialogs (Realwindow) Then
	PriorLine ()
	If (GetWindowTypeCode (HWnd) == WT_ListBox)
	 || (GetWindowTypeCode (Hwnd) == WT_Button) Then
		SayControlGraphic  ()
	EndIf ;(GetwindowTypecode (Hwnd) == WT_ListBox)
	SayLine ()
	Return
EndIf
;Execute the default SayPriorLine script.
PerformScript SayPriorLine ()
EndScript


Script SayNextLine ()
Var
	Handle Hwnd, ;The current window handle.
	String FontName, ;Name of the font.
	Int PointSize, ;Point size of the font.
	Handle RealWindow, ;Real window handle.
	String TheClass ;The current window class.
Let RealWindow = GetRealWindow (GetcurrentWindow ())
	Let HWnd = GetCurrentWindow ()
	Let TheClass = GetWindowclass (Hwnd)
If IsPCCursor ()
 && ControlCheckMarkDialogs (Realwindow) Then
	NextLine ()
	If (GetWindowTypeCode (HWnd) == WT_ListBox)
	 || (GetWindowTypeCode (Hwnd) == WT_Button) Then
;	Say(WpMsg45, ot_message); "checking for graphic"
		SaycontrolGraphic ()
	EndIf ;(GetwindowTypecode (Hwnd) == WT_ListBox)
	SayLine ()
	Return
EndIf
;Execute the default SayNextline script.
PerformScript SayNextLine ()
EndScript

Script SayLine ()
Var
	Handle Hwnd, ;The current window handle.
	Handle RealWindow, ;Real window handle.
	String TheClass ;The current window class.

Let RealWindow = GetRealWindow (GetcurrentWindow ())
If IsPCCursor ()
 && ControlCheckMarkDialogs (Realwindow) Then
	Let HWnd = GetCurrentWindow ()
	Let TheClass = GetWindowclass (Hwnd)
	If (GetWindowTypeCode (HWnd) == WT_ListBox)
	 || (GetWindowTypeCode (Hwnd) == WT_Button) Then
		SaycontrolGraphic ()
	EndIf ;(GetwindowTypecode (Hwnd) == WT_ListBox)
endIf
SayLine ()
EndScript

Script SayPriorPage ()

;Move to the prior page.
{alt+page up}
Pause ()
	SayWindow (Getfocus (), READ_EVERYTHING)
EndScript

Script SayNextPage ()
{alt+page down}
Pause ()
	SayWindow (Getfocus (), READ_EVERYTHING)
EndScript


